/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CTCPSocket.cp,v 1.1 1999/10/26 02:04:54 jason Exp $
____________________________________________________________________________*/


#include <string.h>

#include "pgpMem.h"

#include "CTCPSocket.h"


CTCPSocket::CTCPSocket()
	: mIsListening(false)
{
	OSStatus	err;
	
	// Create the endpoint
	mEndpointRef = ::OTOpenEndpoint(	::OTCreateConfiguration(kTCPName),
										0,
										0,
										&err);
	ThrowIfOTError(err);
	err = ::OTSetBlocking(mEndpointRef);
	ThrowIfOTError(err);
	err = ::OTInstallNotifier(	mEndpointRef,
								NotifyProc,
								this);
	ThrowIfOTError(err);
	err = ::OTUseSyncIdleEvents(	mEndpointRef,
									true);
	ThrowIfOTError(err);
	mSocketType = kPGPSocketTypeStream;
}



CTCPSocket::~CTCPSocket()
{
}



	void
CTCPSocket::Cleanup()
{
	if (! mCanceled) {
		// Make sure we disconnect in an orderly fashion
		switch (::OTLook(mEndpointRef)) {
			case T_DISCONNECT:
			{
				::OTRcvDisconnect(mEndpointRef, nil);
			}
			break;


			case T_ORDREL:
			{
				::OTRcvOrderlyDisconnect(mEndpointRef);
				::OTSndOrderlyDisconnect(mEndpointRef);
			}
			break;
			
			
			default:
			{
				::OTSndOrderlyDisconnect(mEndpointRef);
				::OTRcvOrderlyDisconnect(mEndpointRef);
			}
			break;
		}
	}
}



	void
CTCPSocket::Connect(
	const PGPSocketAddressInternet *	inAddress)
{
	OSStatus	err;
	TCall		sndCall;
	InetAddress	theAddress;
	
	// Bind the endpoint
	DoBind(0);
	
	// Create the TCall
	theAddress.fAddressType = AF_INET;
	theAddress.fPort = inAddress->sin_port;
	theAddress.fHost = inAddress->sin_addr.s_addr;
	sndCall.addr.len = sizeof(theAddress);
	sndCall.addr.buf = (UInt8 *) &theAddress;
	sndCall.addr.maxlen = sizeof(theAddress);
	sndCall.opt.len = 0;
	sndCall.opt.buf = nil;
	sndCall.opt.maxlen = 0;
	sndCall.udata.len = 0;
	sndCall.udata.buf = nil;
	sndCall.udata.maxlen = 0;
	sndCall.sequence = 0;

	err = ::OTSetAsynchronous(mEndpointRef);
	ThrowIfOTError(err);
	
	// Connect
	err = ::OTConnect(	mEndpointRef,
						&sndCall,
						nil);
						
// Perhaps I should just set this sync and do the rcvconnect?
	while (err == kOTNoDataErr) {
		err = ::OTRcvConnect(mEndpointRef, nil);
		if (err == kOTNoDataErr) {
			mInCallback = true;
			if (CallIdleEventHandler() != kPGPError_NoErr) {
				::OTSetSynchronous(mEndpointRef);
				err = ::OTSndDisconnect(mEndpointRef, &sndCall);
				ThrowIfOTError(err);
				Close();
			}
			mInCallback = false;
		}
		if (mCanceled) {
			err = ::OTSetSynchronous(mEndpointRef);
			ThrowIfOTError(err);
			Close();
			ThrowPGPError_(kOTCanceledErr);
		}
	};
	err = ::OTSetSynchronous(mEndpointRef);
	ThrowIfOTError(err);
		
	// Handle disconnects and listens
	while (err == kOTLookErr) {
		OTResult	event;
		
		event = ::OTLook(mEndpointRef);
		if (event == T_LISTEN) {
			TEndpointInfo	info;
			TCall			call;
			InetAddress		address;
			UInt8 *			options;
			
			err = ::OTGetEndpointInfo(mEndpointRef, &info);
			if (err != kOTNoError) {
				ThrowPGPError_(kPGPError_UnknownError);
			} else {
				options = (UInt8 *) ::NewPtr(info.options);
				if (options == nil) {
					ThrowPGPError_(kPGPError_OutOfMemory);
				}
				call.addr.buf = (UInt8 *) &address;
				call.addr.maxlen = sizeof(address);
				call.opt.buf = options;
				call.opt.maxlen = (options == nil) ? 0 : info.options;
				call.udata.buf = nil;
				call.udata.maxlen = 0;
				
				err = ::OTListen(mEndpointRef, &call);
				if (err == kOTNoError) {
					::OTSndDisconnect(mEndpointRef, &call);
				}
				::DisposePtr((Ptr) options);
			}
			err = ::OTRcvConnect(mEndpointRef, nil);
		} else {
			break;
		}
	}
	ThrowIfOTError(err);
}



/*	void
CTCPSocket::Connect(
	const PGPSocketAddressInternet *	inAddress)
{
	OSStatus	err;
	TCall		sndCall;
	InetAddress	theAddress;
	
	// Bind the endpoint
	DoBind(0);
	
	// Create the TCall
	theAddress.fAddressType = AF_INET;
	theAddress.fPort = inAddress->sin_port;
	theAddress.fHost = inAddress->sin_addr.s_addr;
	sndCall.addr.len = sizeof(theAddress);
	sndCall.addr.buf = (UInt8 *) &theAddress;
	sndCall.addr.maxlen = sizeof(theAddress);
	sndCall.opt.len = 0;
	sndCall.opt.buf = nil;
	sndCall.opt.maxlen = 0;
	sndCall.udata.len = 0;
	sndCall.udata.buf = nil;
	sndCall.udata.maxlen = 0;
	sndCall.sequence = 0;
		
	// Connect
	err = ::OTConnect(	mEndpointRef,
						&sndCall,
						nil);
	while (err == kOTLookErr) {
		OTResult	event;
		
		event = ::OTLook(mEndpointRef);
		if (event == T_LISTEN) {
			TEndpointInfo	info;
			TCall			call;
			InetAddress		address;
			UInt8 *			options;
			
			err = ::OTGetEndpointInfo(mEndpointRef, &info);
			if (err != kOTNoError) {
				ThrowPGPError_(kPGPError_UnknownError);
			} else {
				options = (UInt8 *) ::NewPtr(info.options);
				if (options == nil) {
					ThrowPGPError_(kPGPError_OutOfMemory);
				}
				call.addr.buf = (UInt8 *) &address;
				call.addr.maxlen = sizeof(address);
				call.opt.buf = options;
				call.opt.maxlen = (options == nil) ? 0 : info.options;
				call.udata.buf = nil;
				call.udata.maxlen = 0;
				
				err = ::OTListen(mEndpointRef, &call);
				if (err == kOTNoError) {
					::OTSndDisconnect(mEndpointRef, &call);
				}
				::DisposePtr((Ptr) options);
			}
			err = ::OTRcvConnect(mEndpointRef, nil);
		} else {
			break;
		}
	}
	ThrowIfOTError(err);
}
*/

	SInt32
CTCPSocket::Send(
	const void *	inBuffer,
	SInt32			inLength,
	SInt32			inFlags)
{
	OSStatus		result;
	OTFlags			flags = 0;

	(void) inFlags;
	
	result = ::OTSnd(	mEndpointRef,
						(void *) inBuffer,
						inLength,
						flags);
	ThrowIfOTError(result);

	return result;
}



	SInt32
CTCPSocket::SendTo(
	const void *						inBuffer,
	SInt32								inLength,
	const PGPSocketAddressInternet *	inAddress)
{
	(void) inAddress;
	
	return Send(inBuffer, inLength, kPGPSendFlagNone);
}



	SInt32
CTCPSocket::Receive(
	void *	outBuffer,
	SInt32	inLength,
	SInt32	inFlags)
{
	OSStatus		result;
	OTFlags			flags = 0;	
	size_t			numBytes;

	(void) inFlags;
	
	do {
		result = ::OTCountDataBytes(mEndpointRef, &numBytes);
		if (result == kOTNoDataErr) {
			mInCallback = true;
			if (CallIdleEventHandler() != kPGPError_NoErr) {
				Close();
			}
			mInCallback = false;
		}
		if (mCanceled) {
			Close();
			ThrowPGPError_(kOTCanceledErr);
		}
	} while (result == kOTNoDataErr);
	if (result != kOTNoError) {
		numBytes = inLength;
	} else if (numBytes > inLength) {
		numBytes = inLength;
	}
	
	result = ::OTRcv(	mEndpointRef,
						outBuffer,
						numBytes,
						&flags);
	
	// Handle disconnects
	if ((result == kOTLookErr) && (::OTLook(mEndpointRef) == T_ORDREL)) {
		result = 0;
	}
	ThrowIfOTError(result);

	return result;
}



	SInt32
CTCPSocket::ReceiveFrom(
	void *						outBuffer,
	SInt32						inSize,
	PGPSocketAddressInternet *	outAddress,
	SInt32 *					ioAddressLength)
{
	(void) outAddress;
	
	if (ioAddressLength != 0) {
		*ioAddressLength = 0;
	}

	return Receive(outBuffer, inSize, kPGPReceiveFlagNone);	
}



	void
CTCPSocket::Listen(
	SInt32	inMaxBacklog)
{
	DoBind(inMaxBacklog);
	mIsListening = true;
}



	CSocket *
CTCPSocket::Accept(
	PGPSocketAddressInternet *	outAddress,
	SInt32 *					ioAddressLength)
{
	OSStatus	result;
	TCall		theCall;
	InetAddress	theAddress;
	
	// Create the TCall
	theCall.addr.buf = (UInt8 *) &theAddress;
	theCall.addr.maxlen = sizeof(theAddress);
	theCall.opt.buf = nil;
	theCall.opt.maxlen = 0;
	theCall.udata.buf = nil;
	theCall.udata.maxlen = 0;

	result = ::OTListen(	mEndpointRef,
							&theCall);
	ThrowIfOTError(result);
	
	// Accept the connection
	CTCPSocket *	theNewSocket = new CTCPSocket;
	if (theNewSocket == nil) {
		ThrowPGPError_(kPGPError_OutOfMemory);
	}
	
	result = ::OTAccept(	mEndpointRef, 
							theNewSocket->mEndpointRef,
							&theCall);
	if (result != kOTNoError) {
		delete theNewSocket;
		ThrowIfOTError(result);
	}
	
	// Fill in the parms
	*ioAddressLength = sizeof(PGPSocketAddressInternet);
	outAddress->sin_family = kPGPAddressFamilyInternet;
	outAddress->sin_port = theAddress.fPort;
	outAddress->sin_addr.s_addr = theAddress.fHost;
	
	return theNewSocket;
}



	void
CTCPSocket::GetPeerName(
	PGPSocketAddressInternet *	outName)
{
	OSStatus	err;
	TBind		theBind;
	InetAddress	theBoundAddress;
	
	pgpClearMemory(&theBind, sizeof(theBind));
	theBind.addr.buf = (UInt8 *) &theBoundAddress;
	theBind.addr.maxlen = sizeof(theBoundAddress);
	
	err = ::OTGetProtAddress(	mEndpointRef,
								nil,
								&theBind);
	ThrowIfOTError(err);
	if (theBind.addr.len == 0) {
		ThrowPGPError_(kPGPError_SocketsNotConnected);
	}
	pgpClearMemory(outName, sizeof(PGPSocketAddressInternet));
	outName->sin_family = kPGPAddressFamilyInternet;
	outName->sin_port = theBoundAddress.fPort;
	outName->sin_addr.s_addr = theBoundAddress.fHost;
}





